<?php
// Lógica arriba para evitar el Warning de Headers
require_once "auth.php"; // <--- ESTO DEBE SER LA LÍNEA 1
require_once '../config/db.php';

$id = $_GET['id'] ?? null;
if (!$id) { header("Location: categorias.php"); exit; }

$stmt = $pdo->prepare("SELECT * FROM categories WHERE id = ?");
$stmt->execute([$id]);
$cat = $stmt->fetch();

$parents = $pdo->prepare("SELECT id, name FROM categories WHERE parent_id IS NULL AND id != ? ORDER BY name ASC");
$parents->execute([$id]);
$parent_list = $parents->fetchAll();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $description = $_POST['description'];
    $parent_id = !empty($_POST['parent_id']) ? $_POST['parent_id'] : NULL;

    $sql = "UPDATE categories SET name = ?, description = ?, parent_id = ? WHERE id = ?";
    $pdo->prepare($sql)->execute([$name, $description, $parent_id, $id]);
    header("Location: categorias.php");
    exit;
}

require_once 'includes/header.php';
require_once 'includes/sidebar.php';
require_once 'includes/navbar.php';
?>

<main class="flex-1 p-8">
    <div class="max-w-3xl mx-auto">
        <div class="flex items-center gap-4 mb-8">
            <a href="categorias.php" class="w-10 h-10 flex items-center justify-center rounded-full bg-white dark:bg-white/5 border border-gray-200 dark:border-white/10 text-gray-500 hover:text-brand-red transition-colors shadow-sm">
                <i class="ri-arrow-left-line text-xl"></i>
            </a>
            <h1 class="font-display font-black text-3xl dark:text-white uppercase">Editar Categoría</h1>
        </div>

        <form method="POST" class="bg-white dark:bg-brand-dark p-8 rounded-xl border border-gray-100 dark:border-white/5 space-y-6 shadow-xl">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Nombre</label>
                    <input type="text" name="name" value="<?php echo $cat['name']; ?>" required class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 dark:text-white outline-none">
                </div>
                <div>
                    <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Padre</label>
                    <select name="parent_id" class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 dark:text-white outline-none">
                        <option value="">Ninguno (Principal)</option>
                        <?php foreach($parent_list as $p): ?>
                            <option value="<?php echo $p['id']; ?>" <?php echo $cat['parent_id'] == $p['id'] ? 'selected' : ''; ?>>
                                <?php echo $p['name']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>

            <div>
                <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Descripción</label>
                <textarea name="description" rows="3" class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 dark:text-white outline-none"><?php echo $cat['description']; ?></textarea>
            </div>

            <button type="submit" class="w-full bg-brand-red hover:bg-brand-red_hover text-white font-bold uppercase py-4 rounded-xl shadow-lg transition-all transform active:scale-95">Actualizar Categoría</button>
        </form>
    </div>
</main>
<?php require_once 'includes/footer.php'; ?>